# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 7
# Experiment: PMxPM, Run: 3
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR7_strategy.txt
# LLM Suggested Fallback: D

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR7(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not opp_history:  # Round 1
        return "C"
    
    if len(my_history) == 9:  # Round 10
        return "D"
    
    # Check if opponent's code is trivial (always C or always D)
    if "return \"C\"" in opponent_program_code or "return 'C'" in opponent_program_code:
        return "D"
    if "return \"D\"" in opponent_program_code or "return 'D'" in opponent_program_code:
        return "D"
    
    # Check if opponent defected in any of the first 3 rounds
    if len(opp_history) >= 3 and any(move == "D" for move in opp_history[:3]):
        return "D"
    
    # Modified Tit-for-Tat with forgiveness and slight randomness
    if opp_history[-1] == "C":
        if random.random() < 0.1:  # 10% chance to defect even after cooperation
            return "D"
        else:
            return "C"
    else:  # opponent defected last round
        if random.random() < 0.2:  # 20% chance to forgive and cooperate
            return "C"
        else:
            return "D"